<?php
    global $VISUAL_COMPOSER_EXTENSIONS;
	if ((class_exists('WPBakeryShortCode')) && (!class_exists('WPBakeryShortCode_TS_VCSC_Image_SVG'))) {
		class WPBakeryShortCode_TS_VCSC_Image_SVG extends WPBakeryShortCode {};
	};
    $VISUAL_COMPOSER_EXTENSIONS->TS_VCSC_VisualComposer_Element = array(
		"name"                      	=> __( "TS Image SVG", "ts_visual_composer_extend" ),
		"base"                      	=> "TS_VCSC_Image_SVG",
		"icon" 	                    	=> "ts-composer-element-icon-image-svg",
		"category"                  	=> __( "Composium", "ts_visual_composer_extend" ),
		"description"               	=> __("Place an image with SVG effects", "ts_visual_composer_extend"),
		"admin_enqueue_js"        		=> "",
		"admin_enqueue_css"       		=> "",
		"params"                    	=> array(
			// Image Settings
			array(
				"type"              	=> "seperator",
				"param_name"        	=> "seperator_1",
				"seperator"         	=> "Image Settings",
			),
			array(
				"type"                  => "attach_image",
				"holder" 				=> ($VISUAL_COMPOSER_EXTENSIONS->TS_VCSC_EditorImagePreview == "true" ? "img" : ""),
				"heading"               => __( "Select Image", "ts_visual_composer_extend" ),
				"param_name"            => "image",
				"class"					=> "ts_vcsc_holder_image",
				"value"                 => "",
				"admin_label"           => ($VISUAL_COMPOSER_EXTENSIONS->TS_VCSC_EditorImagePreview == "true" ? false : true),
				"description"           => __( "Select the image for the element.", "ts_visual_composer_extend" ),
			),
			array(
				"type"                  => "dropdown",
				"heading"               => __( "Preview Image Source", "ts_visual_composer_extend" ),
				"param_name"            => "content_image_size",
				"width"                 => 150,
				"value"                 => array(
					__( 'Medium Size Image', "ts_visual_composer_extend" )			=> "medium",
					__( 'Large Size Image', "ts_visual_composer_extend" )			=> "large",
					__( 'Full Size Image', "ts_visual_composer_extend" )			=> "full",
				),
				"description"           => __( "Select which image size based on WordPress settings should be used for the preview image.", "ts_visual_composer_extend" ),
			),
			array(
				"type"                  => "dropdown",
				"heading"               => __( "SVG Style", "ts_visual_composer_extend" ),
				"param_name"            => "style",
				"width"                 => 150,
				"value"                 => array(
					__( 'Style 1', "ts_visual_composer_extend" )						=> "imagesvg1",
					__( 'Style 2', "ts_visual_composer_extend" )						=> "imagesvg2",
					__( 'Style 3', "ts_visual_composer_extend" )						=> "imagesvg3",
					__( 'Style 4', "ts_visual_composer_extend" )						=> "imagesvg4",
					__( 'Style 5', "ts_visual_composer_extend" )						=> "imagesvg5",
				),
				"admin_label"           => true,
				"description"           => __( "Select which SVG style should be applied to the image.", "ts_visual_composer_extend" ),
			),
			array(
				"type"              	=> "colorpicker",
				"heading"           	=> __( "SVG Background Color", "ts_visual_composer_extend" ),
				"param_name"        	=> "color_fill",
				"value"             	=> "#ffffff",
				"description"       	=> __( "Define the background color for the SVG shape.", "ts_visual_composer_extend" ),
			),
			array(
				"type"					=> "switch_button",
				"heading"           	=> __( "Apply Grayscale Effect", "ts_visual_composer_extend" ),
				"param_name"        	=> "grayscale",
				"value"             	=> "true",
				"description"       	=> __( "Switch the toggle if you want to apply a grayscale effect to the image.", "ts_visual_composer_extend" )
			),
			// Link Settings
			array(
				"type"              	=> "seperator",
				"param_name"        	=> "seperator_2",
				"seperator"         	=> "Link Settings",
			),
			array(
				"type"                  => "dropdown",
				"heading"               => __( "Button Link", "ts_visual_composer_extend" ),
				"param_name"            => "trigger",
				"width"                 => 150,
				"value"                 => array(
					__( 'Open Image in Lightbox', "ts_visual_composer_extend" )			=> "image",
					__( 'Open Other Page', "ts_visual_composer_extend" )				=> "link",
					__( 'Scroll to Page Section', "ts_visual_composer_extend" )			=> "scroll",
				),
				"admin_label"           => true,
				"description"           => __( "Select the action that should be triggered when clicking on the button.", "ts_visual_composer_extend" ),
			),
			array(
				"type"					=> "switch_button",
				"heading"           	=> __( "Link Full Element", "ts_visual_composer_extend" ),
				"param_name"        	=> "link_container",
				"value"             	=> "false",
				"description"       	=> __( "Switch the toggle if you want to apply the link to the full element instead of just the button.", "ts_visual_composer_extend" )
			),
			array(
				"type" 					=> ($VISUAL_COMPOSER_EXTENSIONS->TS_VCSC_ParameterLinkPicker['enabled'] == "false" ? "vc_link" : "advancedlinks"),
				"heading" 				=> __("Link + Title", "ts_visual_composer_extend"),
				"param_name" 			=> "link",
				"description" 			=> __("Provide a link to another site/page for the Icon Button.", "ts_visual_composer_extend"),
				"dependency"			=> array( 'element' => "trigger", 'value' => 'link' )
			),
			array(
				"type"                  => "dropdown",
				"heading"               => __( "Lightbox Image Source", "ts_visual_composer_extend" ),
				"param_name"            => "lightbox_size",
				"width"                 => 150,
				"value"                 => array(
					__( 'Full Size Image', "ts_visual_composer_extend" )			=> "full",
					__( 'Large Size Image', "ts_visual_composer_extend" )			=> "large",
					__( 'Medium Size Image', "ts_visual_composer_extend" )			=> "medium",
				),
				"description"           => __( "Select which image size based on WordPress settings should be used for the lightbox image.", "ts_visual_composer_extend" ),
				"dependency"			=> array( 'element' => "trigger", 'value' => 'image' )
			),
			// Scroll Settings
			array(
				"type"                  => "textfield",
				"heading"               => __( "Page Scroll Target", "ts_visual_composer_extend" ),
				"param_name"            => "scroll_target",
				"value"                 => "",
				"description"           => __( "Enter the unique ID for the page section you want to scroll to.", "ts_visual_composer_extend" ),
				"dependency"            => array( 'element' => "trigger", 'value' => 'scroll' ),
			),
			array(
				"type" 					=> "devicetype_selectors",
				"heading"           	=> __( "Device Type Scroll Offset", "ts_visual_composer_extend" ),
				"param_name"        	=> "scroll_offset",
				"unit"  				=> "px",
				"collapsed"				=> "true",
				"devices" 				=> array(
					"Desktop"           		=> array("default" => 0, "min" => 0, "max" => 250, "step" => 1),
					"Tablet"            		=> array("default" => 0, "min" => 0, "max" => 250, "step" => 1),
					"Mobile"            		=> array("default" => 0, "min" => 0, "max" => 250, "step" => 1),
				),
				"value"					=> "desktop:0px;tablet:0px;mobile:0px",
				"description"			=> __( "Define an additional scroll offset to account for menu bars and other top fixed elements.", "ts_visual_composer_extend" ),
				"dependency"            => array( 'element' => "trigger", 'value' => 'scroll' ),
			),
			array(
				"type"					=> "nouislider",
				"heading"				=> __( "Page Scroll Speed", "ts_visual_composer_extend" ),
				"param_name"			=> "scroll_speed",
				"value"					=> "2000",
				"min"					=> "1000",
				"max"					=> "10000",
				"step"					=> "100",
				"unit"					=> 'ms',
				"description"			=> __( "Define the speed that should be used to scroll to the section.", "ts_visual_composer_extend" ),
				"dependency"            => array( 'element' => "trigger", 'value' => 'scroll' ),
			),							
			array(
				"type"                 	=> "dropdown",
				"heading"               => __( "Page Scroll Easing", "ts_visual_composer_extend" ),
				"param_name"            => "scroll_effect",
				"edit_field_class"		=> "vc_col-sm-6 vc_column",
				"width"                 => 150,
				"value" 				=> $VISUAL_COMPOSER_EXTENSIONS->TS_VCSC_CSS_Easings_Array,
				"description"           => __( "Select the easing animation that should be applied to the page scroll.", "ts_visual_composer_extend" ),
				"dependency"            => array( 'element' => "trigger", 'value' => 'scroll' ),
			),
			array(
				"type"                  => "switch_button",
				"heading"			    => __( 'Add Target as Hashtag', "ts_visual_composer_extend" ),
				"param_name"		    => "scroll_hashtag",
				"edit_field_class"		=> "vc_col-sm-6 vc_column",
				"value"                 => "false",
				"description"		    => __( "Switch the toggle if you want to add the scroll target to the browser URL via hashtag.", "ts_visual_composer_extend" ),
				"dependency"            => array( 'element' => "trigger", 'value' => 'scroll' ),
			),		
			// Speed Settings
			array(
				"type"              	=> "seperator",
				"param_name"        	=> "seperator_3",
				"seperator"         	=> "Speed Settings",
			),
			array(
				"type"					=> "switch_button",
				"heading"           	=> __( "Change Animation Speeds", "ts_visual_composer_extend" ),
				"param_name"        	=> "speed_change",
				"value"             	=> "false",
				"description"       	=> __( "Switch the toggle if you want to change some animation speeds.", "ts_visual_composer_extend" )
			),
			array(
				"type"                  => "nouislider",
				"heading"               => __( "Speed: SVG Shape", "ts_visual_composer_extend" ),
				"param_name"            => "speed_svg",
				"value"                 => "250",
				"min"                   => "100",
				"max"                   => "2000",
				"step"                  => "50",
				"unit"                  => 'ms',
				"description"           => __( "Define the animation speed for the main SVG shape.", "ts_visual_composer_extend" ),
				"dependency"			=> array( 'element' => "speed_change", 'value' => 'true' )
			),
			array(
				"type"                  => "nouislider",
				"heading"               => __( "Speed: Title", "ts_visual_composer_extend" ),
				"param_name"            => "speed_title",
				"value"                 => "500",
				"min"                   => "100",
				"max"                   => "2000",
				"step"                  => "50",
				"unit"                  => 'ms',
				"description"           => __( "Define the animation speed for the element title.", "ts_visual_composer_extend" ),
				"dependency"			=> array( 'element' => "speed_change", 'value' => 'true' )
			),
			array(
				"type"                  => "nouislider",
				"heading"               => __( "Speed: Message", "ts_visual_composer_extend" ),
				"param_name"            => "speed_message",
				"value"                 => "500",
				"min"                   => "100",
				"max"                   => "2000",
				"step"                  => "50",
				"unit"                  => 'ms',
				"description"           => __( "Define the animation speed for the element message.", "ts_visual_composer_extend" ),
				"dependency"			=> array( 'element' => "speed_change", 'value' => 'true' )
			),
			array(
				"type"                  => "nouislider",
				"heading"               => __( "Speed: Link", "ts_visual_composer_extend" ),
				"param_name"            => "speed_link",
				"value"                 => "500",
				"min"                   => "100",
				"max"                   => "2000",
				"step"                  => "50",
				"unit"                  => 'ms',
				"description"           => __( "Define the animation speed for the element link.", "ts_visual_composer_extend" ),
				"dependency"			=> array( 'element' => "speed_change", 'value' => 'true' )
			),
			// Content Settings
			array(
				"type"              	=> "seperator",
				"param_name"        	=> "seperator_4",
				"seperator"         	=> "Content",
				"group" 				=> "Content",
			),
			array(
				"type"              	=> "textfield",
				"heading"           	=> __( "Title", "ts_visual_composer_extend" ),
				"param_name"        	=> "text_title",
				"value"             	=> "",
				"description"       	=> __( "Enter a title for the element.", "ts_visual_composer_extend" ),
				"group" 				=> "Content",
			),
			array(
				"type"              	=> "colorpicker",
				"heading"           	=> __( "Title Color", "ts_visual_composer_extend" ),
				"param_name"        	=> "color_title",
				"value"             	=> "#3498db",
				"description"       	=> __( "Define the color of the title text.", "ts_visual_composer_extend" ),
				"group" 				=> "Content",
			),
            array(
                "type"					=> "dropdown",
                "heading"				=> __( "Title Wrap", "ts_visual_composer_extend" ),
                "param_name"			=> "title_wrap",
                "width"					=> 150,
                "value"					=> array(
                    __( "Standard DIV", "ts_visual_composer_extend" )		=> "div",
                    __( "H1", "ts_visual_composer_extend" )					=> "h1",
                    __( "H2", "ts_visual_composer_extend" )					=> "h2",
                    __( "H3", "ts_visual_composer_extend" )					=> "h3",
                    __( "H4", "ts_visual_composer_extend" )					=> "h4",
                    __( "H5", "ts_visual_composer_extend" )					=> "h5",
                    __( "H6", "ts_visual_composer_extend" )					=> "h6",
                ),
                "description"			=> __( "Select in which DOM element type the title should be wrapped in; specific theme styling might apply.", "ts_visual_composer_extend" ),
                "standard"				=> "h3",
                "std"					=> "h3",
                "default"				=> "h3",
                "group" 				=> "Content",
            ),	
			array(
				"type"              	=> "textarea",
				"heading"           	=> __( "Message", "ts_visual_composer_extend" ),
				"param_name"        	=> "text_content",
				"value"             	=> "",
				"description"       	=> __( "Enter a message for the element; will be shortened to one line inside element but can be shown in full via tooltip.", "ts_visual_composer_extend" ),
				"group" 				=> "Content",
			),
			array(
				"type"              	=> "colorpicker",
				"heading"           	=> __( "Message Color", "ts_visual_composer_extend" ),
				"param_name"        	=> "color_text",
				"value"             	=> "#333333",
				"description"       	=> __( "Define the color of the message text.", "ts_visual_composer_extend" ),
				"group" 				=> "Content",
			),
			array(
				"type"              	=> "textfield",
				"heading"           	=> __( "Button Text", "ts_visual_composer_extend" ),
				"param_name"        	=> "text_button",
				"value"             	=> "",
				"description"       	=> __( "Enter the button text to be used for the element.", "ts_visual_composer_extend" ),
				"group" 				=> "Content",
			),
			array(
				"type"              	=> "colorpicker",
				"heading"           	=> __( "Button Text Color", "ts_visual_composer_extend" ),
				"param_name"        	=> "color_button_text",
				"value"             	=> "#333333",
				"description"       	=> __( "Define the color of the text in the button.", "ts_visual_composer_extend" ),
				"group" 				=> "Content",
			),
			array(
				"type"              	=> "colorpicker",
				"heading"           	=> __( "Button Background Color", "ts_visual_composer_extend" ),
				"param_name"        	=> "color_button_back",
				"value"             	=> "#ffffff",
				"description"       	=> __( "Define the background color for the button.", "ts_visual_composer_extend" ),
				"dependency"			=> array( 'element' => "style", 'value' => array('imagesvg1', 'imagesvg2', 'imagesvg3', 'imagesvg4') ),
				"group" 				=> "Content",
			),				
			// Tooltip Settings
			array(
				"type"				    => "seperator",
				"param_name"		    => "seperator_5",
				"seperator"				=> "Image Tooltip",
				"group" 				=> "Tooltip",
			),
			array(
				"type"					=> "switch_button",
				"heading"           	=> __( "Use Tooltip", "ts_visual_composer_extend" ),
				"param_name"        	=> "content_tooltip",
				"value"             	=> "true",
				"description"       	=> __( "Switch the toggle if you want to show the full title and description via tooltip as well.", "ts_visual_composer_extend" ),
				"group" 				=> "Tooltip",
			),
			array(
				"type"				    => "dropdown",
				"heading"			    => __( "Tooltip Position", "ts_visual_composer_extend" ),
				"param_name"		    => "content_tooltip_position",
				"value"                 => $VISUAL_COMPOSER_EXTENSIONS->TS_VCSC_ToolTipster_Positions,
				"description"		    => __( "Select the tooltip position in relation to the player.", "ts_visual_composer_extend" ),
				"dependency"            => array( 'element' => "content_tooltip", 'value' => 'true' ),
				"group" 				=> "Tooltip",
			),
			array(
				"type"					=> "nouislider",
				"heading"				=> __( "Tooltip X-Offset", "ts_visual_composer_extend" ),
				"param_name"			=> "tooltipster_offsetx",
				"value"					=> "0",
				"min"					=> "-100",
				"max"					=> "100",
				"step"					=> "1",
				"unit"					=> 'px',
				"description"			=> __( "Define an optional X-Offset for the tooltip position.", "ts_visual_composer_extend" ),
				"dependency"            => array( 'element' => "content_tooltip", 'value' => 'true' ),
				"group" 				=> "Tooltip",
			),
			array(
				"type"					=> "nouislider",
				"heading"				=> __( "Tooltip Y-Offset", "ts_visual_composer_extend" ),
				"param_name"			=> "tooltipster_offsety",
				"value"					=> "0",
				"min"					=> "-100",
				"max"					=> "100",
				"step"					=> "1",
				"unit"					=> 'px',
				"description"			=> __( "Define an optional Y-Offset for the tooltip position.", "ts_visual_composer_extend" ),
				"dependency"            => array( 'element' => "content_tooltip", 'value' => 'true' ),
				"group" 				=> "Tooltip",
			),				
			// Lightbox Settings
			array(
				"type"                  => "seperator",
				"param_name"            => "seperator_6",
				"seperator"				=> "Lightbox Settings",
				"group" 				=> "Lightbox",
			),
			array(
				"type"              	=> "switch_button",
				"heading"			    => __( "Create AutoGroup", "ts_visual_composer_extend" ),
				"param_name"		    => "lightbox_group",
				"value"				    => "true",
				"description"		    => __( "Switch the toggle if you want the plugin to group this image with all other non-gallery images on the page.", "ts_visual_composer_extend" ),
				"group" 				=> "Lightbox",
			),
			array(
				"type"                  => "textfield",
				"heading"               => __( "Group Name", "ts_visual_composer_extend" ),
				"param_name"            => "lightbox_group_name",
				"value"                 => "",
				"admin_label"           => true,
				"description"           => __( "Enter a custom group name to manually build group with other non-gallery items.", "ts_visual_composer_extend" ),
				"dependency"            => array( 'element' => "lightbox_group", 'value' => 'false' ),
				"group" 				=> "Lightbox",
			),		
			array(
				"type"                  => "dropdown",
				"heading"               => __( "Transition Effect", "ts_visual_composer_extend" ),
				"param_name"            => "lightbox_effect",
				"width"                 => 150,
				"value"                 => $VISUAL_COMPOSER_EXTENSIONS->TS_VCSC_Lightbox_Animations,
				"default" 				=> $VISUAL_COMPOSER_EXTENSIONS->TS_VCSC_LightboxDefaultAnimation,
				"std" 					=> $VISUAL_COMPOSER_EXTENSIONS->TS_VCSC_LightboxDefaultAnimation,
				"description"           => __( "Select the transition effect to be used for the image in the lightbox.", "ts_visual_composer_extend" ),
				"group" 				=> "Lightbox",
			),
			array(
				"type"                  => "dropdown",
				"heading"               => __( "Backlight Effect", "ts_visual_composer_extend" ),
				"param_name"            => "lightbox_backlight",
				"width"                 => 150,
				"value"                 => array(
					__( 'Auto Color', "ts_visual_composer_extend" )					=> "auto",
					__( 'Custom Color', "ts_visual_composer_extend" )				=> "custom",
					__( 'Transparent Backlight', "ts_visual_composer_extend" )     	=> "hideit",
				),
				"description"           => __( "Select the backlight effect for the image.", "ts_visual_composer_extend" ),
				"group" 				=> "Lightbox",
			),
			array(
				"type"                  => "colorpicker",
				"heading"               => __( "Custom Backlight Color", "ts_visual_composer_extend" ),
				"param_name"            => "lightbox_backlight_color",
				"value"                 => "#ffffff",
				"description"           => __( "Define the backlight color for the lightbox image.", "ts_visual_composer_extend" ),
				"dependency"            => array( 'element' => "lightbox_backlight", 'value' => 'custom' ),
				"group" 				=> "Lightbox",
			),				
			// Other Settings
			array(
				"type"				    => "seperator",
				"param_name"		    => "seperator_7",
				"seperator"				=> "Other Settings",
				"group" 				=> "Other Settings",
			),
			array(
				"type"                  => "nouislider",
				"heading"               => __( "Margin: Top", "ts_visual_composer_extend" ),
				"param_name"            => "margin_top",
				"value"                 => "0",
				"min"                   => "0",
				"max"                   => "200",
				"step"                  => "1",
				"unit"                  => 'px',
				"description"           => __( "Select the top margin for the element.", "ts_visual_composer_extend" ),
				"group" 				=> "Other Settings",
			),
			array(
				"type"                  => "nouislider",
				"heading"               => __( "Margin: Bottom", "ts_visual_composer_extend" ),
				"param_name"            => "margin_bottom",
				"value"                 => "0",
				"min"                   => "0",
				"max"                   => "200",
				"step"                  => "1",
				"unit"                  => 'px',
				"description"           => __( "Select the bottom margin for the element.", "ts_visual_composer_extend" ),
				"group" 				=> "Other Settings",
			),
			array(
				"type"                  => "textfield",
				"heading"               => __( "Define ID Name", "ts_visual_composer_extend" ),
				"param_name"            => "el_id",
				"value"                 => "",
				"description"           => __( "Enter an unique ID for the element.", "ts_visual_composer_extend" ),
				"group" 				=> "Other Settings",
			),
			array(
				"type"                  => "tag_editor",
				"heading"           	=> __( "Extra Class Names", "ts_visual_composer_extend" ),
				"param_name"            => "el_class",
				"value"                 => "",
				"description"      		=> __( "Enter additional class names for the element.", "ts_visual_composer_extend" ),
				"group" 				=> "Other Settings",
			),
		)
	);		
	if ($VISUAL_COMPOSER_EXTENSIONS->TS_VCSC_VisualComposer_LeanMap == "true") {
		return $VISUAL_COMPOSER_EXTENSIONS->TS_VCSC_VisualComposer_Element;
	} else {			
		vc_map($VISUAL_COMPOSER_EXTENSIONS->TS_VCSC_VisualComposer_Element);
	};
?>